/**
* \file: GstreamerVideoSink.cpp
*
* \version: 1.0
*
* \release: $Name:$
*
* Video sink endpoint implementation using Gstreamer
*
* \component: Baidu CarLife
*
* \author: P. Govindaraju / RBEB/GM / Pradeepa.Govindaraju@in.bosch.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
************************************************************************/

#include <GstreamerVideoSink.h>
#include "GstreamerVideoSinkImpl.h"

namespace adit { namespace bdcl {
using std::string;
using std::unique_ptr;

GstreamerVideoSink::GstreamerVideoSink(IAditVideoSinkCallbacks* inCallbacks, CoreCallbackDealer* inCallbackDealer)
: AditVideoSink(inCallbacks, inCallbackDealer)
{
    impl = move(unique_ptr<GstreamerVideoSinkImpl>(new GstreamerVideoSinkImpl(inCallbacks, inCallbackDealer)));
}

GstreamerVideoSink::~GstreamerVideoSink()
{

}

void GstreamerVideoSink::setConfigItem(string inKey, string inValue)
{
    impl->setConfigItem(inKey, inValue);
}

bool GstreamerVideoSink::initialize()
{
    return impl->initialize();
}

void GstreamerVideoSink::teardown()
{
    impl->teardown();
}

void GstreamerVideoSink::configureStream()
{
    impl->configureStream();
}

bool GstreamerVideoSink::playbackStart()
{
    return impl->playbackStart();
}

void GstreamerVideoSink::playbackPause()
{
    impl->playbackPause();
}

} } /* namespace adit { namespace bdcl { */

